<?php

if(empty($_POST["g-recaptcha-response"])) header("Location: index.php"); //Redirect if page is entered without using reCAPTCHA

$response = $_POST["g-recaptcha-response"]; //reCAPTCHA response

$secret = ""; //Secret key form reCAPTCHA admin page

$captcha = file_get_contents("https://www.google.com/recaptcha/api/siteverify?secret=$secret&response=$response"); //Get response from Google

$captchaJson = json_decode($captcha); //Decode json encoded response

if(!$captchaJson->success) //Check if client is a robot
{
    $result = "You are a robot!";
    $class = "bad";
}
else
{
    $result = "You are a human!";
    $class = "good";
}

?>

<html>
    <head>
        
        <meta charset="utf-8">
        <title>Google's reCAPTCHA tutorial</title>
        <meta name="description" content="reCAPTCHA is really easy to use with PHP!">
        <meta name="keywords" content="recaptcha, tutorial">
        
        <link rel="stylesheet" href="style.css">
        
        <script src='https://www.google.com/recaptcha/api.js'></script>
        
    </head>
    <body>
        
        <div class="result <?php echo $class;?>">
            <div class="text"><?php echo $result;?></div>
        </div>
        
    </body>
</html>